<?php
include("../config.php");

if (PHP_SAPI == 'cli')
die('Este ejemplo sólo se puede ejecutar desde un navegador Web');
 
/** Incluye PHPExcel */
require_once 'lib/Classes/PHPExcel.php';
// Crear nuevo objeto PHPExcel
$objPHPExcel = new PHPExcel();
 
// Propiedades del documento
$objPHPExcel->getProperties()->setCreator("SURA")
->setLastModifiedBy("SURA")
->setTitle("Office 2010 XLSX SURA")
->setSubject("Office 2010 XLSX SURA")
->setDescription("Documento de prueba para Office 2010 XLSX, generado usando clases de PHP.")
->setKeywords("office 2010 openxml php")
->setCategory("Reporte - SURA");
 
 
 
// Combino las celdas desde A1 hasta E1
$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:C1');
 
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'REPORTE DTCONTROL DÍA 5 - SURA')
            ->setCellValue('A2', 'CÓDIGO')
            ->setCellValue('B2', 'FECHA - DÍA 5')
            ->setCellValue('C2', 'PT - DÍA 5');
$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
 
$objPHPExcel->getActiveSheet()->getStyle('A1:I2')->applyFromArray($boldArray);
 
//Ancho de las columnas
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
 
$sql="SELECT * FROM reporte_2  order by codigo";
$query=mysqli_query($con,$sql);
$cel=3;//Numero de fila donde empezara a crear  el reporte
while ($row=mysqli_fetch_array($query)){
$codigo=$row['codigo'];
$fecha_d1=$row['fecha_d5'];
$d1_pt=$row['d5_pt'];
$a="A".$cel;
$b="B".$cel;
$c="C".$cel;


// Agregar datos
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue($a, $codigo)
            ->setCellValue($b, $fecha_d1)
            ->setCellValue($c, $d1_pt);
$cel+=1;
}
 
/*Fin extracion de datos MYSQL*/
$rango="A2:$c" ;
$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
);
$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);
// Cambiar el nombre de hoja de cálculo
$objPHPExcel->getActiveSheet()->setTitle('Reporte DTCONTROL');
 
 
// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
$objPHPExcel->setActiveSheetIndex(0);
 
 
// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="reporte_dtcontrol_dia5.xls"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');
 
// Si usted está sirviendo a IE a través de SSL , a continuación, puede ser necesaria la siguiente
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0
 
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
exit;